﻿﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
﻿using System.Security.Policy;
﻿using System.Text.RegularExpressions;
using DataCollectorScriptLibrary;
﻿using Reporter.Model;
using Reporter.Model.ProcessedItems;

public class TRN_ABC_ELMU_ScriptWrapper : InnerCode
{

    public TRN_ABC_ELMU_ScriptWrapper(CollectionContainer container)
        : base(container)
    {

    }


    #region Code

    #region Collected keys

    /*
    * Collected keys: emailfrom;emailto;filename;filepath;IsActive;IssueName;MaszCompany;MaszID;ProcessName;subject;TariContractNo;TariPartner;Title;Url;Workid;JcId
    */

    #endregion

    #region Load

    /*
    #LOAD "Utilities\Utilities.ReportLogProvider.cs"
    #LOAD "Utilities\Utilities.IntervalTimerProvider.cs"
    #LOAD "Utilities\Utilities.HierarchyCacheProvider.cs"
    #LOAD "Utilities\Utilities.ProductivityProvider.cs"
    #LOAD "Utilities\Utilities.WorkItemExtConcatenatorProvider.cs"
    #LOAD "Utilities\Utilities.ReportControlProvider.cs"
    #LOAD "Utilities\Utilities.TasknameDecoratorProvider.cs"
    #LOAD "BaseReports\BaseReports.Custom.cs"
    #LOAD "BaseReports\BaseReports.SimpleAggregator.cs"
    #LOAD "Utilities\Utilities.ConfigurationControlProvider.cs"
    #LOAD "Utilities\Utilities.Utilities.cs"
    #LOAD "Utilities\Utilities.WorktimeSettingsProvider.cs"
    */

    #endregion

    #region ForceDataPopulation

    // GetTaskById(1); GetTableFromFile("INPUT_ADC_Productivity", "INPUT_Task"); GetTableFromFile("INPUT_ADC_Productivity", "INPUT_Process"); GetTableFromFile("INPUT_ADC_Productivity", "INPUT_Url"); GetTableFromFile("INPUT_ADC_Productivity", "INPUT_FilePath");                    
    // GetWorktimeSettingsForDay(1, new DateTime(2017,1,1));  GetDailySchedulesForUser(1,  new DateTime(2017,1,1)); GetHolidaysForUser(1); GetSickLeavesForUser(1);

    #endregion

    #region Declarations

    public ConfigurationControlProvider Configuration = new ConfigurationControlProvider();
    public InputKeyWordProvider InputCollections;
    public string InputFileName = "INPUT_ABC_Keywords";
    public string InputKeywordSheetName = "Keywords";
    public string InputSpecialEmailSheetName = "email-special";
    public string InputEmailSheetName = "e-mail";
    public string InputRegexSheetName = "regexes";
    public string InputUrlSheetName = "urls";
    public static bool BigData = false;
    public HashSet<int> ProjectIds = new HashSet<int>() {240313};
    public HashSet<int> TaskIds = new HashSet<int>() {239211};
    public const bool IsLeaderReport = true;
    public ReportConfiguration ReportConfig;

    #endregion

    #region Local configuration

    public bool ConfigureLocal()
    {
        var CollectedKeyList = new Dictionary<string, string>
        {
            {"CrmCompany", "CrmCompany"},
            {"CrmTaxNo", "CrmTaxNo"},
            {"emailfrom", "emailfrom"},
            {"emailto", "emailto"},
            {"filename", "filename"},
            {"filepath", "filepath"},
            {"IssueName", "IssueName"},
            {"MaszCompany", "MaszCompany"},
            {"MaszID", "MaszID"},
            {"ProcessName", "ProcessName"},
            {"subject", "subject"},
            {"TariContractNo", "TariContractNo"},
            {"TariPartner", "TariPartner"},
            {"Title", "Title"},
            {"Url", "Url"},
            {"Workid", "Workid"},
        };

        Configuration.TasknameDecoratorProviderDefaultConfig.CollectableKeyList = CollectedKeyList;
        ReportLogProviderConfig.DefaultLogLevel = LogLevels.Info;

        ReportLogProviderConfig.SetLogLevelForProvider("Report Control", LogLevels.Verbose);
        Configuration.ConcatenatorConfig.IsDummy = false;
        return true;
    }

    #endregion

    #region Local initialization

    public bool InitializeLocal()
    {
        InputCollections = new InputKeyWordProvider(Configuration, InputFileName, InputKeywordSheetName,
            InputEmailSheetName, InputSpecialEmailSheetName);
        ReportConfig = new ReportConfiguration(Configuration, InputCollections, InputFileName, InputKeywordSheetName,
            InputSpecialEmailSheetName, InputEmailSheetName, InputRegexSheetName, InputUrlSheetName, BigData,
            ProjectIds, TaskIds);
        Configuration.ReportControl.RegisterReport(new TRN_ABC_ELMU_Script("TRN_ABC_ELMU_Script", ReportConfig));

        return true;
    }

    #endregion

    #region Main

    public void Execute()
    {
        if (Configuration.Configure(this) && ConfigureLocal() && Configuration.Initialize() && InitializeLocal())
        {
            Configuration.ReportControl.Execute();
        }
    }

    #endregion

    #region Utility classes

    #region TRN_ABC_ELMU_Script

    public class TRN_ABC_ELMU_Script : BaseCustomReport
    {
        private ConfigurationControlProvider Configuration;
        private List<string> CapturedKeyList;
        private InputKeyWordProvider InputCollections;
        private string LastTransactionName = "";
        private string LastTranId = "";
        private string LastTranIdWoTimestamp = "";
        private string LastTranCategory = "";
        private string LastTranStatus = "";
        private HashSet<int> ProjectIds;
        private HashSet<int> TaskIds;
        private string OutlookContentTempFilePath = @"\Outlook.Content\";

        public Dictionary<KeyTransactionReport, ValueGeneral> AbcReportDictionary =
            new Dictionary<KeyTransactionReport, ValueGeneral>();

        public Dictionary<string, TransactionProperties> JcIdTransactionDictionary =
            new Dictionary<string, TransactionProperties>();

        public TRN_ABC_ELMU_Script(string LogReferenceName, ReportConfiguration ReportConfig)
            : base(LogReferenceName, ReportConfig.Configuration)
        {
            this.Configuration = ReportConfig.Configuration;
            this.InputCollections = ReportConfig.InputCollections;
            this.ProjectIds = ReportConfig.ProjectIds;
            this.TaskIds = ReportConfig.TaskIds;
            CapturedKeyList = GetKeyList(ReportConfig.Configuration.ReportControl.GetRuntimeContext()
                .ReportContextData);

            OutputWriterList.Add(WriteOutput);
        }

        public override bool doProcess(WorkItemExt Xtup)
        {
            var dictKey = new KeyTransactionReport(Xtup, Configuration);
            AbcBusinessLogic(Xtup, ref dictKey);
            if (IsLeaderReport)
            {
                dictKey.TranID = "";
            }
            ValueGeneral dictValue;

            if (!AbcReportDictionary.TryGetValue(dictKey, out dictValue))
            {
                AbcReportDictionary.Add(dictKey, new ValueGeneral());
                dictValue = AbcReportDictionary[dictKey];
            }
            dictValue.Add(Xtup.tup);
            return true;
        }

        public override void PostProcess()
        {
            var resultDictionary = new Dictionary<KeyTransactionReport, ValueGeneral>();
            foreach (var entry in AbcReportDictionary)
            {
                TransactionProperties TransactionPropertiesValue;
                if (!String.IsNullOrWhiteSpace(entry.Key.JcId) &&
                    JcIdTransactionDictionary.TryGetValue(entry.Key.JcId, out TransactionPropertiesValue))
                {
                    entry.Key.TranID = TransactionPropertiesValue.TranId;
                    entry.Key.TransactionName = TransactionPropertiesValue.TransactionName;
                    entry.Key.TranCategory = TransactionPropertiesValue.TranCategory;
                }

                ValueGeneral resultValue;
                if (!resultDictionary.TryGetValue(entry.Key, out resultValue))
                {
                    resultDictionary.Add(entry.Key, entry.Value);
                }
                else
                {
                    resultValue.Add(entry.Value);
                }
            }
            AbcReportDictionary = resultDictionary;
        }

        private void AbcBusinessLogic(WorkItemExt Xtup, ref KeyTransactionReport DictKey)
        {
            var url = GetValueOrDefault(Xtup.tup.Values, "Url");
            var emailFrom = GetValueOrDefault(Xtup.tup.Values, "emailfrom");
            var processName = GetValueOrDefault(Xtup.tup.Values, "ProcessName");
            var subject = GetValueOrDefault(Xtup.tup.Values, "subject");
            var emailTo = GetValueOrDefault(Xtup.tup.Values, "emailto");
            string issueName = GetValueOrDefault(Xtup.tup.Values, "IssueName");
            var JcId = GetValueOrDefault(Xtup.tup.Values, "JcId");
            var hasEmailTo = !String.IsNullOrWhiteSpace(emailTo);
            var hasEmailFrom = !String.IsNullOrWhiteSpace(emailFrom);
            var hasProcessName = !String.IsNullOrWhiteSpace(processName);
            var hasUrl = !String.IsNullOrWhiteSpace(url);
            var tupStartDateString = helper.UtcToLocalDate(Xtup.tup.StartDate).ToString("G");
            var parentTaskIdList = Tasks.GetParentIds(Xtup.tup.WorkId);
            var hasJcId = !String.IsNullOrWhiteSpace(JcId);
            var filepath = Utilities.GetValueMemberFromXtup(Xtup, "filepath");
            var hasFilePath = !String.IsNullOrWhiteSpace(filepath);
            var concatenatedDataCollectors = ConcatenateDataCollectors(Xtup);
            string matchedString;
            string key = "";
            bool isTransaction = false;
            if (hasJcId)
            {
                DictKey.JcId = JcId;
            }
            var TaskName = Tasks.GetName(Xtup.tup.WorkId);

            if (parentTaskIdList.Any(a => ProjectIds.Contains(a)))
            {
                var projectTaskName = Tasks.GetName(Xtup.tup.WorkId);
                DictKey.TransactionName = "Projekt";
                DictKey.TranCategory = projectTaskName;
                DictKey.TranID = String.Format("[Projekt]={0}", Tasks.GetName(Xtup.tup.WorkId));
                DictKey.TranStatus = "Projekt";

                isTransaction = true;
            }

            if (!isTransaction && Xtup.tup.Type == ItemType.Mobile)
            {
                isTransaction = true;

                foreach (var element in InputCollections.InputKeySet)
                {
                    DictKey.TranID = String.Format("{0}={1}", "[Mobil]", TaskName);

                    if (TaskName.IndexOf(element, StringComparison.OrdinalIgnoreCase) > -1)
                    {
                        DictKey.TranCategory = "[Mobil]";
                        DictKey.TransactionName = element;

                        break;
                    }
                    else
                    {
                        DictKey.TranCategory = String.Format("Mobil: {0}", TaskName);
                        DictKey.TransactionName = "OTHER";
                    }
                }
            }
            else
            {
                if (!isTransaction && Xtup.tup.Type == ItemType.AdhocMeeting ||
                    Xtup.tup.Type == ItemType.CalendarMeeting)
                {
                    var productOfMeeting =
                        InputCollections.InputKeySet.FirstOrDefault(
                            product => TaskName.IndexOf(product, StringComparison.OrdinalIgnoreCase) > -1);
                    if (String.IsNullOrWhiteSpace(productOfMeeting))
                    {
                        isTransaction = false;
                    }
                    else
                    {
                        if (productOfMeeting.IndexOf("projekt", StringComparison.OrdinalIgnoreCase) > -1)
                        {
                            DictKey.TransactionName = "Projekt";
                            DictKey.TranCategory = productOfMeeting;
                            DictKey.TranID = String.Format("[Projekt]={0}", Tasks.GetName(Xtup.tup.WorkId));
                            DictKey.TranStatus = "Projekt";
                        }
                        else
                        {
                            DictKey.TransactionName = productOfMeeting;
                            DictKey.TranCategory = "[Meeting feladat]";
                            DictKey.TranID = String.Format("{0}={1}", "[Meeting feladat]", productOfMeeting);
                            DictKey.TranStatus = "Termék";
                        }

                        isTransaction = true;
                    }
                }
                if (!isTransaction &&
                    TryMatchInput(concatenatedDataCollectors, InputCollections.InputProjectKeywordCollection, out key,
                        out matchedString))
                {
                    DictKey.TransactionName = "Projekt";
                    DictKey.TranCategory = key;
                    DictKey.TranID = String.Format("[Projekt]={0}", Tasks.GetName(Xtup.tup.WorkId));
                    isTransaction = true;
                }
                if (!String.IsNullOrWhiteSpace(issueName) && !isTransaction)
                {
                    if (TryMatchInput(issueName, InputCollections.InputKeywordsCollection, out key, out matchedString))
                    {
                        DictKey.TransactionName = key;
                        DictKey.TranCategory = "[Címkézett e-mail]";
                        DictKey.TranID = String.Format("{0}={1}", "[Címkézett e-mail]", matchedString);
                        DictKey.TranStatus = "Termék";

                        if (hasJcId)
                        {
                            TransactionProperties valueTransactionProperties = null;
                            if (!JcIdTransactionDictionary.TryGetValue(JcId, out valueTransactionProperties))
                            {
                                JcIdTransactionDictionary.Add(JcId,
                                    new TransactionProperties(IsLeaderReport ? "" : DictKey.TranID,
                                        DictKey.TransactionName, DictKey.TranCategory, DictKey.TranStatus));
                            }
                            else
                            {
                                valueTransactionProperties.TranId = IsLeaderReport ? "" : DictKey.TranID;
                                valueTransactionProperties.TransactionName = DictKey.TransactionName;
                                valueTransactionProperties.TranCategory = DictKey.TranCategory;
                                valueTransactionProperties.TranStatus = DictKey.TranStatus;
                            }
                        }
                        isTransaction = true;
                    }
                }
                if (!isTransaction)
                {
                    if ((hasEmailFrom && TryMatchInput(emailFrom, InputCollections.InputEmailsCollection, out key,
                             out matchedString))
                        || (hasEmailTo && TryMatchInput(emailTo, InputCollections.InputEmailsCollection, out key,
                                out matchedString)))
                    {
                        DictKey.TransactionName = key;
                        DictKey.TranCategory = "[E-mail]";
                        DictKey.TranID = String.Format("{0}={1}", "[E-mail]", matchedString);
                        DictKey.TranStatus = "Termék";
                        isTransaction = true;
                    }
                    if (!isTransaction && hasEmailFrom &&
                        TryMatchInput(emailFrom, InputCollections.InputKeywordsCollection, out key, out matchedString))
                    {
                        DictKey.TransactionName = key;
                        DictKey.TranCategory = "[Keywords]";
                        DictKey.TranID = String.Format("{0}={1}", "[Keywords]", matchedString);
                        DictKey.TranStatus = "Termék";
                        isTransaction = true;
                    }
                }
                if (hasUrl && !isTransaction)
                {
                    if (TryMatchInput(url, InputCollections.InputUrlsCollection, out key, out matchedString))
                    {
                        DictKey.TransactionName = key;
                        DictKey.TranCategory = "[Url]";
                        DictKey.TranID = String.Format("{0}={1}", "[Url]", matchedString);
                        DictKey.TranStatus = "Termék";
                        isTransaction = true;
                    }
                    if (!isTransaction && TryMatchInput(url, InputCollections.InputKeywordsCollection, out key,
                            out matchedString))
                    {
                        DictKey.TransactionName = key;
                        DictKey.TranCategory = "[Keywords]";
                        DictKey.TranID = String.Format("{0}={1}", "[Keywords]", matchedString);
                        DictKey.TranStatus = "Termék";
                        isTransaction = true;
                    }
                }

                if (!String.IsNullOrWhiteSpace(concatenatedDataCollectors) && !isTransaction)
                {
                    if (TryMatchInput(concatenatedDataCollectors, InputCollections.InputKeywordsCollection, out key,
                        out matchedString))
                    {
                        DictKey.TransactionName = key;
                        DictKey.TranCategory = "[Keywords]";
                        DictKey.TranID = String.Format("{0}={1}", "[Keywords]", matchedString);
                        DictKey.TranStatus = "Termék";
                        isTransaction = true;
                    }
                    if (!isTransaction &&
                        TryMatchInput(concatenatedDataCollectors, InputCollections.InputIdPatternsCollection, out key,
                            out matchedString))
                    {
                        DictKey.TransactionName = key;
                        DictKey.TranCategory = "[Regex Keywords]";
                        DictKey.TranID = String.Format("{0}={1}", "[Regex Keywords]", matchedString);
                        DictKey.TranStatus = "Termék";
                        isTransaction = true;
                    }
                }
                if (!isTransaction)
                {
                    if (hasEmailFrom &&
                        TryMatchInput(emailFrom, InputCollections.InputSpecialEmailsCollection, out key,
                            out matchedString)
                        || (hasEmailTo &&
                            TryMatchInput(emailTo, InputCollections.InputSpecialEmailsCollection, out key,
                                out matchedString)))
                    {

                        if (!String.IsNullOrWhiteSpace(subject) &&
                            TryMatchInput(subject, InputCollections.InputKeywordsCollection, out key,
                                out matchedString))
                        {
                            DictKey.TransactionName = key;
                            DictKey.TranCategory = "[Special-email]";
                            DictKey.TranID = String.Format("{0}={1}", "[Special-email]", matchedString);
                            DictKey.TranStatus = "Termék";
                        }
                        else
                        {
                            DictKey.TransactionName = "Villamosenergia";
                            DictKey.TranCategory = "[E-mail]";
                            DictKey.TranID = String.Format("{0}={1}", "[E-mail]", matchedString);
                            DictKey.TranStatus = "Termék";
                        }
                        isTransaction = true;
                    }
                }

                if (!isTransaction && TaskIds.All(a => a != Xtup.tup.WorkId))
                {
                    DictKey.TranCategory = String.Format("OTHER: {0}", TaskName);
                    DictKey.TransactionName = "OTHER";
                    //DictKey.TranID = String.Format("{0}={1} ({2})", "[OTHER]",Tasks.GetName(Xtup.tup.WorkId), tupStartDateString);
                    DictKey.TranID = String.Format("{0}={1}", "[OTHER]", TaskName);
                    DictKey.TranStatus = "OTHER";
                    isTransaction = true;
                }
            }

            if (isTransaction)
            {
                if (String.IsNullOrWhiteSpace(LastTranIdWoTimestamp) || !LastTranIdWoTimestamp.Equals(DictKey.TranID))
                {
                    LastTranIdWoTimestamp = DictKey.TranID;
                    DictKey.TranID += " (" + tupStartDateString + ")";
                }
                else
                {
                    DictKey.TranID = LastTranId;
                }

                LastTranId = DictKey.TranID;
                LastTranCategory = DictKey.TranCategory;
                LastTransactionName = DictKey.TransactionName;
                LastTranStatus = DictKey.TranStatus;
                DictKey.IsFirstMatchingTup = true;

            }
            else if (!String.IsNullOrWhiteSpace(LastTranId) && hasFilePath &&
                     filepath.IndexOf(OutlookContentTempFilePath, StringComparison.OrdinalIgnoreCase) > -1)
            {
                DictKey.TranCategory = LastTranCategory;
                DictKey.TransactionName = LastTransactionName;
                DictKey.TranID = LastTranId;
                DictKey.TranStatus = LastTranStatus;
            }
            else if ( /*!String.IsNullOrWhiteSpace(LastTranId) &&*/ Xtup.IsProductive)
            {
                DictKey.TranCategory = String.Format("Produktív: {0}", Tasks.GetName(Xtup.tup.WorkId));
                DictKey.TransactionName = "OTHER";
                DictKey.TranID = String.Format("{0}={1}", "[Produktív]", Tasks.GetName(Xtup.tup.WorkId));
                DictKey.TranStatus = "OTHER";
                isTransaction = true;
            }
            else
            {
                DictKey.TransactionName = "<OTHER>";
                DictKey.TranCategory = hasUrl
                    ? String.Format("{0} - {1}", processName, Utilities.GetURLShort(url, 2))
                    : processName;
                DictKey.TranID = String.Format("Last: {0}", LastTranId);
            }

        }

        private bool TryMatchInput(string DataCollector, Dictionary<string, HashSet<string>> InputDictionary,
            out string Key, out string MatchedString)
        {
            Key = "E+";
            MatchedString = "";
            if (String.IsNullOrWhiteSpace(DataCollector))
                return false;

            foreach (var dictEntry in InputDictionary)
            {
                foreach (var hashSetItem in dictEntry.Value)
                {
                    if (DataCollector.IndexOf(hashSetItem, StringComparison.OrdinalIgnoreCase) > -1)
                    {
                        Key = dictEntry.Key;
                        MatchedString = hashSetItem;
                        return true;
                    }
                }
            }
            return false;
        }

        private bool TryMatchInput(string DataCollector, Dictionary<string, HashSet<Regex>> InputDictionary,
            out string Key, out string MatchedString)
        {
            Key = "E+";
            MatchedString = "";
            if (String.IsNullOrWhiteSpace(DataCollector))
                return false;

            foreach (var dictEntry in InputDictionary)
            {
                foreach (var hashSetItem in dictEntry.Value)
                {
                    var match = hashSetItem.Match(DataCollector);
                    if (match.Success)
                    {
                        Key = dictEntry.Key;
                        MatchedString = match.Value;
                        return true;
                    }
                }
            }
            return false;
        }

        private string ConcatenateDataCollectors(WorkItemExt Xtup)
        {
            var resultBuilder = new System.Text.StringBuilder();
            if (Xtup.tup.Type == ItemType.Pc)
            {
                foreach (var key in CapturedKeyList)
                {
                    var dataCollector = GetValueOrDefault(Xtup.tup.Values, key);
                    if (!String.IsNullOrWhiteSpace(dataCollector))
                    {
                        if (resultBuilder.Length == 0)
                            resultBuilder.Append(dataCollector);
                        else
                        {
                            resultBuilder.AppendFormat(";{0}", dataCollector);
                        }

                    }
                }
            }
            if (Xtup.tup.Type == ItemType.CalendarMeeting)
            {
                resultBuilder.AppendFormat(";{0}", ((CalendarMeetingWorkItem) Xtup.tup).Title);
            }
            if (Xtup.tup.Type == ItemType.AdhocMeeting)
            {
                resultBuilder.AppendFormat(";{0}", ((AdhocMeetingWorkItem) Xtup.tup).Title);
            }

            return resultBuilder.ToString();
        }

        private List<string> GetKeyList(ReportContext ReportContext)
        {
            var resultList = new List<string>();
            const StringComparison compareOption = StringComparison.OrdinalIgnoreCase;

            foreach (var key in ReportContext.CapturedKeys)
            {
                if ((key.IndexOf("emailfrom", compareOption) > -1)
                    || (key.IndexOf("IsActive", compareOption) > -1)
                    || (key.IndexOf("Url", compareOption) > -1)
                    || (key.IndexOf("emailto", compareOption) > -1)
                    || (key.IndexOf("IssueName", compareOption) > -1))
                    continue;

                resultList.Add(key);
            }
            return resultList;
        }


        public int WriteOutput()
        {
            if (AbcReportDictionary.Count == 0)
            {
                return 0;
            }
            int outputRowCount = 0;
            var sheet = helper.dataSet.Tables.Add("RAW_TransactionReport");

            sheet.Columns.Add("TaskId");
            sheet.Columns.Add("TaskName");
            sheet.Columns.Add("TaskPath");
            sheet.Columns.Add("UserId");
            sheet.Columns.Add("UserName");
            sheet.Columns.Add("UserPath");
            sheet.Columns.Add("UserNameWithPath");
            sheet.Columns.Add("GroupLevel2");
            sheet.Columns.Add("GroupLevel1");
            sheet.Columns.Add("TransactionName");
            sheet.Columns.Add("TranType");
            sheet.Columns.Add("TranCategory");
            sheet.Columns.Add("TranID");
            sheet.Columns.Add("TranStatus");
            sheet.Columns.Add("DecoratedNameTask");
            sheet.Columns.Add("DateSplit", typeof(DateTime));
            sheet.Columns.Add("ClosingDate", typeof(string));
            sheet.Columns.Add("ClosingDateTime", typeof(DateTime?));
            sheet.Columns.Add("Active PC", typeof(TimeSpan));
            sheet.Columns.Add("Inactive PC", typeof(TimeSpan));
            sheet.Columns.Add("Adhoc", typeof(TimeSpan));
            sheet.Columns.Add("Manual", typeof(TimeSpan));
            sheet.Columns.Add("Calendar", typeof(TimeSpan));
            sheet.Columns.Add("MobileNormal", typeof(TimeSpan));
            sheet.Columns.Add("MobileCall", typeof(TimeSpan));
            sheet.Columns.Add("Holiday", typeof(TimeSpan));
            sheet.Columns.Add("SickLeave", typeof(TimeSpan));
            sheet.Columns.Add("Offline", typeof(TimeSpan));
            sheet.Columns.Add("Total", typeof(TimeSpan));
            sheet.Columns.Add("TotalWithOffline", typeof(TimeSpan));
            sheet.Columns.Add("IsBusyTime", typeof(TimeSpan));
            sheet.Columns.Add("CaseTime", typeof(TimeSpan));
            sheet.Columns.Add("StartDateTime", typeof(DateTime));
            sheet.Columns.Add("EndDateTime", typeof(DateTime));
            sheet.Columns.Add("CountOfRows");
            sheet.Columns.Add("CountAsTran");
            sheet.Columns.Add("CountAsUser");
            sheet.Columns.Add("IsInOffice");
            sheet.Columns.Add("IsInOvertime");
            sheet.Columns.Add("ProductiveState");

            sheet.Columns.Add("YearOfDate");
            sheet.Columns.Add("MonthOfDate");
            sheet.Columns.Add("WeekOfDate");
            sheet.Columns.Add("DayOfDate");

            foreach (var keyValuePair in AbcReportDictionary)
            {
                if (String.IsNullOrWhiteSpace(keyValuePair.Key.TransactionName)) continue;
                if (keyValuePair.Key.TransactionName == "<OTHER>" &&
                    (BigData || !TransactionReportPlugin.EnabledTransactionReportKeys["OTHER"])) continue;
                if (keyValuePair.Key.TransactionName == "<OTHER>" &&
                    keyValuePair.Value.Total.TotalSeconds < 1) continue;

                var row = sheet.NewRow();
                var colIdx = 0;
                row[colIdx++] = keyValuePair.Key.TaskId;
                row[colIdx++] = Tasks.GetName(keyValuePair.Key.TaskId);
                row[colIdx++] = Tasks.GetPath(keyValuePair.Key.TaskId, new HashSet<int> {-1, -2, -3});
                row[colIdx++] = keyValuePair.Key.UserId;
                row[colIdx++] = Users.GetName(keyValuePair.Key.UserId);
                row[colIdx++] = Users.GetPath(keyValuePair.Key.UserId, new HashSet<int> {-3, -2, -1});
                row[colIdx++] = Users.GetNameWithPath(keyValuePair.Key.UserId, new HashSet<int> {-3, -2, -1});
                row[colIdx++] = Users.GetPath(keyValuePair.Key.UserId, 2);
                row[colIdx++] = Users.GetPath(keyValuePair.Key.UserId, 1);
                row[colIdx++] = keyValuePair.Key.TransactionName;
                row[colIdx++] = "";
                row[colIdx++] = keyValuePair.Key.TranCategory;
                row[colIdx++] = keyValuePair.Key.TranID;
                row[colIdx++] = "";
                row[colIdx++] =
                    keyValuePair.Key
                        .DecoratedNameTask; /*keyValuePair.Key.IsFirstMatchingTup ? "(!)" + keyValuePair.Key.DecoratedNameTask :*/
                row[colIdx++] = keyValuePair.Key.DateSplit;
                row[colIdx++] = "";
                row[colIdx++] = "";
                row[colIdx++] = keyValuePair.Value.Active;
                row[colIdx++] = keyValuePair.Value.Inactive;
                row[colIdx++] = keyValuePair.Value.Adhoc;
                row[colIdx++] = keyValuePair.Value.Manual;
                row[colIdx++] = keyValuePair.Value.Calendar;
                row[colIdx++] = keyValuePair.Value.MobileNormal;
                row[colIdx++] = keyValuePair.Value.MobileCall;
                row[colIdx++] = keyValuePair.Value.Holiday;
                row[colIdx++] = keyValuePair.Value.SickLeave;
                row[colIdx++] = keyValuePair.Value.Offline;
                row[colIdx++] = keyValuePair.Value.Total;
                row[colIdx++] = keyValuePair.Value.TotalWithOffline;
                row[colIdx++] = keyValuePair.Value.IsBusyTime;
                row[colIdx++] = keyValuePair.Value.CaseTime;
                row[colIdx++] = helper.UtcToLocalDate(keyValuePair.Value.StartDate);
                row[colIdx++] = helper.UtcToLocalDate(keyValuePair.Value.EndDate);
                row[colIdx++] = "";
                row[colIdx++] = "";
                row[colIdx++] = "";
                row[colIdx++] = keyValuePair.Key.IsInOffice;
                row[colIdx++] = "";
                row[colIdx++] = keyValuePair.Key.ProductiveState;
                if (keyValuePair.Key.DateSplit.HasValue)
                {
                    row[colIdx++] = keyValuePair.Key.DateSplit.Value.Year;
                    row[colIdx++] = keyValuePair.Key.DateSplit.Value.Month;
                    row[colIdx++] = "";
                    row[colIdx] = keyValuePair.Key.DateSplit.Value.Day;
                }
                sheet.Rows.Add(row);
                outputRowCount++;
            }

            return outputRowCount;
        }
    }

    #endregion

    #region ReportConfig

    public class ReportConfiguration
    {
        public ConfigurationControlProvider Configuration;
        public InputKeyWordProvider InputCollections;
        public string InputFileName;
        public string InputKeywordSheetName;
        public string InputSpecialEmailSheetName;
        public string InputEmailSheetName;
        public string InputRegexSheetName;
        public string InputUrlSheetName;
        public static bool BigData = false;
        public HashSet<int> ProjectIds;
        public HashSet<int> TaskIds;

        public ReportConfiguration(ConfigurationControlProvider Configuration, InputKeyWordProvider InputCollections,
            string InputFileName, string InputKeywordSheetName, string InputSpecialEmailSheetName,
            string InputEmailSheetName,
            string InputRegexSheetName, string InputUrlSheetName, bool BigData, HashSet<int> ProjectIds,
            HashSet<int> TaskIds)
        {
            this.Configuration = Configuration;
            this.InputCollections = InputCollections;
            this.InputFileName = InputFileName;
            this.InputKeywordSheetName = InputKeywordSheetName;
            this.InputSpecialEmailSheetName = InputSpecialEmailSheetName;
            this.InputEmailSheetName = InputEmailSheetName;
            this.InputRegexSheetName = InputRegexSheetName;
            this.InputUrlSheetName = InputUrlSheetName;
            this.ProjectIds = ProjectIds;
            this.TaskIds = TaskIds;
        }
    }

    #endregion

    #region KeyTransactionReport

    public class KeyTransactionReport
    {
        public int TaskId;
        public int UserId;
        public string TransactionName;
        public int TranType; //open or close
        public string TranCategory;
        public string TranID;
        public string TranStatus;
        public string DecoratedNameTask; //task, details
        public DateTime? DateSplit;

        public bool IsInOffice;

        //public bool IsInOvertime;
        public string ProductiveState;

        public string IncludedWorkName;
        public string JcId;
        private ConfigurationControlProvider Configuration;
        public bool IsFirstMatchingTup = false;

        // Rewrite hash calculation because of class, need to get more simple hash calculation
        public override int GetHashCode()
        {
            return TaskId.GetHashCode()
                   + UserId.GetHashCode()
                   + (TransactionName ?? "").GetHashCode()
                   + TranType.GetHashCode()
                   + (TranCategory ?? "").GetHashCode()
                   + (TranID ?? "").GetHashCode()
                   + (TranStatus ?? "").GetHashCode()
                   + (DecoratedNameTask ?? "").GetHashCode()
                   + DateSplit.GetHashCode()
                   + (JcId ?? "").GetHashCode()
                   + (ProductiveState ?? "").GetHashCode();
        }

        // Rewrite Equals function beceause of class   
        public override bool Equals(object obj)
        {
            var collectedDataKey = obj as KeyTransactionReport;

            if (collectedDataKey == null)
            {
                return false;
            }

            return TaskId == collectedDataKey.TaskId
                   && UserId == collectedDataKey.UserId
                   && TransactionName == collectedDataKey.TransactionName
                   && TranType == collectedDataKey.TranType
                   && TranCategory == collectedDataKey.TranCategory
                   && TranID == collectedDataKey.TranID
                   && TranStatus == collectedDataKey.TranStatus
                   && DecoratedNameTask == collectedDataKey.DecoratedNameTask
                   && DateSplit == collectedDataKey.DateSplit
                   && JcId == collectedDataKey.JcId
                   && ProductiveState == collectedDataKey.ProductiveState;
        }

        public KeyTransactionReport(WorkItemExt Xtup, ConfigurationControlProvider Configuration)
        {
            this.Configuration = Configuration;
            var helper = Configuration.ReportControl.GetRuntimeContext().helper;
            //tup general inputs
            TaskId = Xtup.tup.WorkId;
            UserId = Xtup.tup.UserId;
            var processName = GetValueOrDefault(Xtup.tup.Values, "ProcessName");
            var title = GetValueOrDefault(Xtup.tup.Values, "Title");
            var url = GetValueOrDefault(Xtup.tup.Values, "Url");
            var filePath = GetValueOrDefault(Xtup.tup.Values, "filepath");
            var fileName = GetValueOrDefault(Xtup.tup.Values, "filename");
            var emailFrom = GetValueOrDefault(Xtup.tup.Values, "emailfrom");
            var emailTo = GetValueOrDefault(Xtup.tup.Values, "emailto");
            var emailSubject = GetValueOrDefault(Xtup.tup.Values, "subject");
            var issueName = GetValueOrDefault(Xtup.tup.Values, "IssueName");


            var hasEmailFrom = !String.IsNullOrWhiteSpace(emailFrom);
            var hasSubject = !String.IsNullOrWhiteSpace(emailSubject);
            var hasFileName = !String.IsNullOrWhiteSpace(fileName);
            var hasTitle = !String.IsNullOrWhiteSpace(title);
            var hasUrl = !String.IsNullOrWhiteSpace(url);
            var taskName = helper.GetWorkName(Xtup.tup.WorkId);
            var hasTaskName = (Xtup.tup.Type == ItemType.AdhocMeeting || Xtup.tup.Type == ItemType.Manual ||
                               Xtup.tup.Type == ItemType.CalendarMeeting);
            var hasIssueName = !String.IsNullOrWhiteSpace(issueName);

            //determining: DecoratedNameTask + IsIncluded(!) - if not match in process list, then not ncluded task(!)
            //??? IncludedWorkName = TransactionReportPlugin.GetWorkNameFromTup(url, processName);
            if (BigData)
            {
                DecoratedNameTask = null;
            }
            else
            {
                DecoratedNameTask = Configuration.TasknameDecorator.GetDecoratedTaskname(Xtup);
                if (Xtup.tup.Type == ItemType.CalendarMeeting)
                {
                    var calendarMeetingWorkitem = (CalendarMeetingWorkItem) Xtup.tup;
                    if (!String.IsNullOrWhiteSpace(calendarMeetingWorkitem.Title))
                    {
                        DecoratedNameTask += " (CalendarTitle: " + calendarMeetingWorkitem.Title + ")";
                    }
                }
                if (Xtup.tup.Type == ItemType.AdhocMeeting)
                {
                    var adhocMeetingWorkitem = (AdhocMeetingWorkItem) Xtup.tup;
                    if (!String.IsNullOrWhiteSpace(adhocMeetingWorkitem.Title))
                    {
                        DecoratedNameTask += "(AdhocTitle: " + adhocMeetingWorkitem.Title + ")";
                    }
                }
                //if (!String.IsNullOrWhiteSpace(IncludedWorkName)) DecoratedNameTask = (hasTaskName ? taskName + ", " : "") + IncludedWorkName;
                //else DecoratedNameTask = (hasTaskName ? taskName : "") + processName;
                //if (hasUrl) DecoratedNameTask += " (" + url + ")";
                //if (hasFileName) DecoratedNameTask += " (" + filePath + "/" + fileName + ")";
                //if (hasEmailFrom) DecoratedNameTask += " (" + emailFrom + " => " + emailTo + ")";
                //if (hasSubject) DecoratedNameTask += " (" + emailSubject + ")";
                //if (hasIssueName) DecoratedNameTask += " (" + issueName + ")";
                //if (hasTitle) DecoratedNameTask += " (" + title + ")";
            }

            //determining: TaskId, UserId, DateSplit
            IsInOffice = GetValueOrDefault(Xtup.tup.Values, "IsInOffice") == "1";
            //IsInOvertime = GeneralFunctions.IsOvertime(Xtup.tup);

            ProductiveState = Xtup.IsProductive ? "Productive" : "Non-Productive";

        }

        public KeyTransactionReport Clone()
        {
            var key = new KeyTransactionReport(this);
            return key;
        }

        public KeyTransactionReport(KeyTransactionReport key)
        {
            TaskId = key.TaskId;
            UserId = key.UserId;
            TransactionName = key.TransactionName;
            if (TransactionReportPlugin.EnabledTransactionReportKeys["TranCategory"])
                TranCategory = key.TranCategory;
            if (TransactionReportPlugin.EnabledTransactionReportKeys["TranID"])
                TranID = key.TranID;
            if (TransactionReportPlugin.EnabledTransactionReportKeys["TranStatus"])
                TranStatus = key.TranStatus;
            if (TransactionReportPlugin.EnabledTransactionReportKeys["DecoratedNameTask"])
                DecoratedNameTask = key.DecoratedNameTask; //task, details
            if (TransactionReportPlugin.EnabledTransactionReportKeys["DateSplit"])
                DateSplit = key.DateSplit;
            if (TransactionReportPlugin.EnabledTransactionReportKeys["IsInOffice"])
                IsInOffice = key.IsInOffice;

            if (TransactionReportPlugin.EnabledTransactionReportKeys["ProductiveState"])
                ProductiveState = key.ProductiveState;
            if (!TransactionReportPlugin.EnabledTransactionReportKeys["OTHER"] &&
                TransactionName == TransactionReportPlugin.OtherName
            ) //if other is disabled, then not creating item (setting each value to null)
            {

                DateSplit = null;
                DecoratedNameTask = null;
                TranStatus = null;
                TranID = null;
                TranType = 0;
                TranCategory = null;
                UserId = 0;
                TaskId = 0;
                TransactionName = null;
            }
            if (!TransactionReportPlugin.EnabledTransactionReportKeys["UserId"])
                UserId = 0;
            if (!TransactionReportPlugin.EnabledTransactionReportKeys["TaskId"])
                TaskId = 0;
            TranType = key.TranType;
        }


    }

    #endregion

    #region TransactionReport plugin

    public class TransactionReportPlugin
    {
        public static Dictionary<string, bool> EnabledTransactionReportKeys = new Dictionary<string, bool>
        {
            {"DateSplit", true},
            {"DecoratedNameTask", true},
            {"TranStatus", true},
            {"TranID", true},
            {"TranCategory", true},
            {"IsInOffice", true},
            {"IsInOvertime", true},
            {"OTHER", true},
            {"TaskId", true},
            {"UserId", true},
            {"ShowAfterClosed", true},
            {"ProductiveState", false},
        };

        public static string LastTranName = null;
        public static string LastTranID = null;
        public static string LastCategory = null;
        public static string LastStatus = null;
        public static string OtherName = "<OTHER>";
        public static int? TempUserID;
        public static DateTime? TempDateTime;

        public Dictionary<KeyTransactionReport, ValueGeneral> DictMain =
            new Dictionary<KeyTransactionReport, ValueGeneral>();

        public Dictionary<KeyTransactionReport, ValueGeneral> TempDictMain =
            new Dictionary<KeyTransactionReport, ValueGeneral>();

        public Dictionary<KeyTransactionReport, ValueGeneral> DictMainOrg =
            new Dictionary<KeyTransactionReport, ValueGeneral>();

        public Dictionary<string, Tuple<bool, DateTime, DateTime>> DictClosedItems =
            new Dictionary<string, Tuple<bool, DateTime, DateTime>>();

        public Dictionary<string, bool> DictCounter = new Dictionary<string, bool>();
        public Dictionary<string, string> CompanyNameCache = new Dictionary<string, string>();
        private int lineCounter = 0;
        private int startLevel = 0;

        //if (!TempDateTime.HasValue || !TempUserID.HasValue || !TempDateTime.Value.Equals ( keys[0]. Key.DateSplit) || TempUserID.Value != tup.UserId)
        //{
        //	TempDateTime = keys[0].Key.DateSplit;
        //	TempUserID = tup.UserId;

        //	LastTranName = null;
        //	LastTranID = null;
        //	LastCategory = null;
        //	LastStatus = null;
        //}

        //	private var processName = GetValueOrDefault(tup.Values, "ProcessName");
        //	private var title = GetValueOrDefault(tup.Values, "Title");
        //	private var url = GetValueOrDefault(tup.Values, "Url");
        //	private var filePath = GetValueOrDefault(tup.Values, "filepath");
        //	private var fileName = GetValueOrDefault(tup.Values, "filename");
        //	private var emailFrom = GetValueOrDefault(tup.Values, "emailfrom");
        //	private var emailTo = GetValueOrDefault(tup.Values, "emailto");
        //	private var emailSubject = GetValueOrDefault(tup.Values, "subject");

        //	private var hasEmailFrom = !String.IsNullOrWhiteSpace(emailFrom);
        //	private var hasEmailTo = !String.IsNullOrWhiteSpace(emailTo);
        //	private var hasSubject = !String.IsNullOrWhiteSpace(emailSubject);
        //	private var hasFileName = !String.IsNullOrWhiteSpace(fileName);
        //	private var hasFilePath = !String.IsNullOrWhiteSpace(filePath);
        //	private var hasTitle = !String.IsNullOrWhiteSpace(title);
        //	private var hasUrl = !String.IsNullOrWhiteSpace(url);
        //	private var taskName = Helper.GetWorkName(tup.WorkId);

        //	private var hasTaskName = (tup.Type == ItemType.AdhocMeeting || tup.Type == ItemType.Manual ||
        //							   tup.Type == ItemType.CalendarMeeting);

        //	private var hasProcessName = !String.IsNullOrWhiteSpace(processName);

        public void KpiTransname()
        {
            EnabledTransactionReportKeys["DateSplit"] = false;
            EnabledTransactionReportKeys["DecoratedNameTask"] = false;
            EnabledTransactionReportKeys["TranStatus"] = false;
            EnabledTransactionReportKeys["TranID"] = true;
            EnabledTransactionReportKeys["TranCategory"] = true;
            EnabledTransactionReportKeys["UserId"] = true;
            EnabledTransactionReportKeys["TaskId"] = false;
            EnabledTransactionReportKeys["OTHER"] = true;
            EnabledTransactionReportKeys["ShowAfterClosed"] = true;
            FnAggregateDict();
        }

        public void KpiCategory()
        {
            EnabledTransactionReportKeys["DateSplit"] = false;
            EnabledTransactionReportKeys["DecoratedNameTask"] = false;
            EnabledTransactionReportKeys["TranStatus"] = false;
            EnabledTransactionReportKeys["TranID"] = false;
            EnabledTransactionReportKeys["TranCategory"] = true;
            EnabledTransactionReportKeys["UserId"] = true;
            EnabledTransactionReportKeys["TaskId"] = false;
            EnabledTransactionReportKeys["OTHER"] = false;
            EnabledTransactionReportKeys["ShowAfterClosed"] = true;
            FnAggregateDict();
        }

        public void KpiClosedOnly()
        {
            EnabledTransactionReportKeys["DateSplit"] = false;
            EnabledTransactionReportKeys["DecoratedNameTask"] = true;
            EnabledTransactionReportKeys["TranStatus"] = true;
            EnabledTransactionReportKeys["TranID"] = true;
            EnabledTransactionReportKeys["TranCategory"] = true;
            EnabledTransactionReportKeys["UserId"] = true;
            EnabledTransactionReportKeys["TaskId"] = true;
            EnabledTransactionReportKeys["OTHER"] = false;
            EnabledTransactionReportKeys["ShowAfterClosed"] = false;
            FnAggregateDict();
        }

        public void FnLevelUp()
        {
            startLevel++;
            switch (startLevel)
            {
                case 1:
                    EnabledTransactionReportKeys["IsInOffice"] = false;
                    EnabledTransactionReportKeys["IsInOvertime"] = false;
                    break;
                case 2:
                    EnabledTransactionReportKeys["DateSplit"] = false;
                    break;
                case 3:
                    EnabledTransactionReportKeys["DecoratedNameTask"] = false;
                    break;
                case 4:
                    EnabledTransactionReportKeys["TranStatus"] = false;
                    break;
                case 5:
                    EnabledTransactionReportKeys["OTHER"] = false;
                    break;
                case 6:
                    EnabledTransactionReportKeys["TranID"] = false;
                    break;
                case 7:
                    EnabledTransactionReportKeys["ShowAfterClosed"] = false;
                    break;
            }
        }

        public void FnAggregateDict()
        {
            try
            {
                TempDictMain.Clear();
                foreach (var item in DictMain)
                {
                    var tempKey = new KeyTransactionReport(item.Key);
                    ValueGeneral value;
                    if (!TempDictMain.TryGetValue(tempKey, out value))
                    {
                        value = new ValueGeneral();
                        TempDictMain.Add(tempKey, value);
                    }
                    value.Add(item.Value);
                }

                DictMain = TempDictMain;
                lineCounter = DictMain.Count();
            }
            catch (InvalidOperationException)
            {
                //Log("plugin_TransactionReport:fnAggregateDict error!");
            }
        }
    }

    #endregion

    #region TransactionValueClass

    public class ValueGeneral
    {
        public TimeSpan Active;
        public TimeSpan Inactive;
        public TimeSpan Adhoc;
        public TimeSpan Calendar;
        public TimeSpan Manual;
        public TimeSpan MobileNormal;
        public TimeSpan MobileCall;
        public TimeSpan Holiday;
        public TimeSpan SickLeave;
        public TimeSpan Offline;
        public TimeSpan Total;
        public TimeSpan TotalWithOffline;
        public TimeSpan IsBusyTime;

        public TimeSpan CaseTime
        {
            get { return Active + Adhoc + MobileNormal + MobileCall + Calendar; }
        }

        public DateTime StartDate;
        public DateTime EndDate;
        public int Count;


        public ValueGeneral()
        {
            Active = TimeSpan.Zero;
            Inactive = TimeSpan.Zero;
            Adhoc = TimeSpan.Zero;
            Calendar = TimeSpan.Zero;
            Manual = TimeSpan.Zero;
            MobileNormal = TimeSpan.Zero;
            Holiday = TimeSpan.Zero;
            SickLeave = TimeSpan.Zero;
            Offline = TimeSpan.Zero;
            Total = TimeSpan.Zero;
            TotalWithOffline = TimeSpan.Zero;
            IsBusyTime = TimeSpan.Zero;
            Count = 0;
            StartDate = DateTime.MaxValue;
            EndDate = DateTime.MinValue;
        }

        private TimeSpan offline = TimeSpan.Zero;

        public ValueGeneral Add(WorkItem item)
        {
            var sw = new Stopwatch();
            sw.Start();
            switch (item.Type)
            {
                case ItemType.AdhocMeeting:
                    Adhoc += item.Duration;
                    break;
                case ItemType.CalendarMeeting:
                    Calendar += item.Duration;
                    break;
                case ItemType.Holiday:
                    Holiday += item.Duration;
                    break;
                case ItemType.Manual:
                    Manual += item.Duration;
                    break;
                case ItemType.Mobile:
                    var mobileWorkItem = (MobileWorkItem) item;
                    if (mobileWorkItem.MobileWorkitemType == MobileWorkitemType.CallBased)
                    {
                        MobileCall += item.Duration;
                    }
                    else
                    {
                        MobileNormal += item.Duration;
                    }
                    break;
                case ItemType.Pc:
                    if (item.WorkId != -1)
                    {
                        var isActive = GetValueOrDefault(item.Values, "IsActive");
                        if (isActive == "1") Active += item.Duration;
                        else /*if (isActive == "0")*/ Inactive += item.Duration;

                        var isBusy = GetValueOrDefault(item.Values, "IsBusyTime");
                        if (isBusy == "1") IsBusyTime += item.Duration;
                    }
                    else
                        offline += item.Duration;
                    break;
                case ItemType.SickLeave:
                    SickLeave += item.Duration;
                    break;
            }

            Total += item.Duration - offline;
            offline = TimeSpan.Zero;
            TotalWithOffline += item.Duration;
            Count++;

            if (StartDate > item.StartDate)
                StartDate = item.StartDate;
            if (EndDate < item.EndDate)
                EndDate = item.EndDate;

            return this;
        }

        public ValueGeneral Add(ValueGeneral other)
        {
            Active += other.Active;
            Inactive += other.Inactive;
            Adhoc += other.Adhoc;
            Calendar += other.Calendar;
            Manual += other.Manual;
            MobileNormal += other.MobileNormal;
            MobileCall += other.MobileCall;
            Holiday += other.Holiday;
            SickLeave += other.SickLeave;
            Offline += other.Offline;
            Total += other.Total;
            TotalWithOffline += other.TotalWithOffline;
            IsBusyTime += other.IsBusyTime;
            Count += other.Count;

            if (StartDate > other.StartDate)
                StartDate = other.StartDate;
            if (EndDate < other.EndDate)
                EndDate = other.EndDate;

            return this;
        }
    }

    #endregion

    #region JcIssueCollection

    public class TransactionProperties
    {
        public string TranId;
        public string TransactionName;
        public string TranCategory;
        public string TranStatus;

        public TransactionProperties(string TranId, string TransactionName, string TranCategory, string TranStatus)
        {
            this.TranId = TranId;
            this.TransactionName = TransactionName;
            this.TranCategory = TranCategory;
            this.TranStatus = TranStatus;
        }
    }

    #endregion

    #region TRN_ABC_LoadKeywordsFromFile

    public class InputKeyWordProvider : ISourceDataProvider
    {
        public Dictionary<string, HashSet<string>> InputProjectKeywordCollection =
            new Dictionary<string, HashSet<string>>();

        public Dictionary<string, HashSet<string>> InputKeywordsCollection = new Dictionary<string, HashSet<string>>();
        public Dictionary<string, HashSet<string>> InputEmailsCollection = new Dictionary<string, HashSet<string>>();

        public Dictionary<string, HashSet<string>> InputSpecialEmailsCollection =
            new Dictionary<string, HashSet<string>>();

        public Dictionary<string, HashSet<string>> InputUrlsCollection = new Dictionary<string, HashSet<string>>();
        public Dictionary<string, HashSet<Regex>> InputIdPatternsCollection = new Dictionary<string, HashSet<Regex>>();

        public HashSet<string> InputKeySet = new HashSet<string>();
        private ConfigurationControlProvider Configuration;
        private string InputFileName;
        private string InputKeywordSheetName;
        private string InputEmailSheetName;
        private string InputSpecialEmailSheetName;

        public InputKeyWordProvider(ConfigurationControlProvider Configuration, string InputFileName,
            string InputKeywordSheetName, string InputEmailSheetName, string InputSpecialEmailSheetName)
        {
            this.Configuration = Configuration;
            this.InputFileName = InputFileName;
            this.InputKeywordSheetName = InputKeywordSheetName;
            this.InputEmailSheetName = InputEmailSheetName;
            this.InputSpecialEmailSheetName = InputSpecialEmailSheetName;
            LoadKeywordsFromInput();
            LoadEmailsFromInput();
            LoadSpecialEmailsFromInput();
            LoadUrlsFromInput();
            LoadIdPatternsFromInput();
            LoadProjectKeywordsFromInput();
        }

        public void LoadProjectKeywordsFromInput()
        {
            var helper = Configuration.ReportControl.GetRuntimeContext().helper;
            var inputSheet = helper.GetTableFromFile("INPUT_ABC_Keywords", "projekt kulcsszavak");
            if (inputSheet == null || inputSheet.Rows.Count == 0) return;
            //var inputSheet = helper.GetTableFromFile(InputFileName, InputKeywordSheetName);
            HashSet<string> inputKeywordValue;
            foreach (var row in inputSheet.Rows)
            {
                var key = row[0].ToString();

                if (!InputProjectKeywordCollection.TryGetValue(key, out inputKeywordValue))
                {
                    InputKeySet.Add(key);
                    InputProjectKeywordCollection.Add(key, new HashSet<string>());
                    inputKeywordValue = InputProjectKeywordCollection[key];
                }
                inputKeywordValue.Add(row[1].ToString());
            }
        }

        public void LoadKeywordsFromInput()
        {
            var helper = Configuration.ReportControl.GetRuntimeContext().helper;
            var inputSheet = helper.GetTableFromFile("INPUT_ABC_Keywords", "keywords");
            if (inputSheet == null || inputSheet.Rows.Count == 0) return;
            //var inputSheet = helper.GetTableFromFile(InputFileName, InputKeywordSheetName);
            HashSet<string> inputKeywordValue;
            foreach (var row in inputSheet.Rows)
            {
                var key = row[0].ToString();

                if (!InputKeywordsCollection.TryGetValue(key, out inputKeywordValue))
                {
                    InputKeySet.Add(key);
                    InputKeywordsCollection.Add(key, new HashSet<string>());
                    inputKeywordValue = InputKeywordsCollection[key];
                }
                inputKeywordValue.Add(row[1].ToString());
            }
        }

        public void LoadEmailsFromInput()
        {
            var helper = Configuration.ReportControl.GetRuntimeContext().helper;
            var inputSheet = helper.GetTableFromFile("INPUT_ABC_Keywords", "e-mail");
            if (inputSheet == null || inputSheet.Rows.Count == 0) return;
            //var inputSheet = helper.GetTableFromFile(InputFileName, InputEmailSheetName);
            HashSet<string> inputEmailValue;
            foreach (var row in inputSheet.Rows)
            {
                var key = row[0].ToString();

                if (!InputEmailsCollection.TryGetValue(key, out inputEmailValue))
                {
                    InputKeySet.Add(key);
                    InputEmailsCollection.Add(key, new HashSet<string>());
                    inputEmailValue = InputEmailsCollection[key];
                }
                inputEmailValue.Add(row[1].ToString());
            }
        }

        public void LoadUrlsFromInput()
        {
            var helper = Configuration.ReportControl.GetRuntimeContext().helper;
            var inputSheet = helper.GetTableFromFile("INPUT_ABC_Keywords", "url");
            if (inputSheet == null || inputSheet.Rows.Count == 0) return;
            //var inputSheet = helper.GetTableFromFile(InputFileName, InputEmailSheetName);
            HashSet<string> inputUrlValue;
            foreach (var row in inputSheet.Rows)
            {
                var key = row[0].ToString();

                if (!InputUrlsCollection.TryGetValue(key, out inputUrlValue))
                {
                    InputKeySet.Add(key);
                    InputUrlsCollection.Add(key, new HashSet<string>());
                    inputUrlValue = InputUrlsCollection[key];
                }
                inputUrlValue.Add(row[1].ToString());
            }
        }

        public void LoadSpecialEmailsFromInput()
        {
            //InputSpecialEmailSheetName
            var helper = Configuration.ReportControl.GetRuntimeContext().helper;
            var inputSheet = helper.GetTableFromFile("INPUT_ABC_Keywords", "special-email");
            if (inputSheet == null || inputSheet.Rows.Count == 0) return;
            //var inputSheet = helper.GetTableFromFile(InputFileName, InputSpecialEmailSheetName);
            HashSet<string> inputSpecialEmailValue;
            foreach (var row in inputSheet.Rows)
            {
                var key = row[0].ToString();

                if (!InputSpecialEmailsCollection.TryGetValue(key, out inputSpecialEmailValue))
                {
                    InputKeySet.Add(key);
                    InputSpecialEmailsCollection.Add(key, new HashSet<string>());
                    inputSpecialEmailValue = InputSpecialEmailsCollection[key];
                }
                inputSpecialEmailValue.Add(row[1].ToString());
            }
        }

        private void LoadIdPatternsFromInput()
        {
            var regexOptions = RegexOptions.IgnoreCase | RegexOptions.Compiled;
            var helper = Configuration.ReportControl.GetRuntimeContext().helper;
            var inputSheet = helper.GetTableFromFile("INPUT_ABC_Keywords", "regex keywords");
            if (inputSheet == null || inputSheet.Rows.Count == 0) return;
            HashSet<Regex> inputIdPatternValue;
            foreach (var row in inputSheet.Rows)
            {
                var key = row[0].ToString();
                if (!InputIdPatternsCollection.TryGetValue(key, out inputIdPatternValue))
                {
                    InputKeySet.Add(key);
                    InputIdPatternsCollection.Add(key, new HashSet<Regex>());
                    inputIdPatternValue = InputIdPatternsCollection[key];
                }
                inputIdPatternValue.Add(new Regex(row[1].ToString(), regexOptions));
            }
        }

        public void OutputSourceData()
        {
            var helper = Configuration.ReportControl.GetRuntimeContext().helper;
            var sheet = helper.dataSet.Tables.Add("RAW_SourceData");
            sheet.Columns.Add("Commodity");
            sheet.Columns.Add("Keyword");

            foreach (var inputEntry in InputKeywordsCollection)
            {
                var colIdx = 0;
                var row = sheet.NewRow();
                foreach (var keyword in inputEntry.Value)
                {
                    row[colIdx++] = inputEntry.Key;
                    row[colIdx++] = keyword;
                }
            }
        }
    }

    #endregion

    #region LoadUserGroupCategorizationInput

    public class ELMU_UserGroupCategorizationInputLoader : ISourceDataProvider
    {
        private Dictionary<int, string> UserCategories;
        private ConfigurationControlProvider Configuration;
        public ELMU_UserGroupCategorizationInputLoader(ConfigurationControlProvider Configuration)
        {
            this.Configuration = Configuration;
            UserCategories = new Dictionary<int, string>();
            LoadSourceData();
        }

        private void LoadSourceData()
        {
            var helper = Configuration.ReportControl.GetRuntimeContext().helper;
            var inputSheet = helper.GetTableFromFile("", "");
            if (inputSheet == null || inputSheet.Rows.Count == 0) return;

            foreach (var row in inputSheet.Rows)
            {
                int userId;
                Int32.TryParse(row[0].ToString(), out userId);
                string categoryName;
                if(!UserCategories.TryGetValue(userId, out categoryName))
                {
                    UserCategories.Add(userId, row[3].ToString());
                }
            }
        }

        public void OutputSourceData()
        {
        }
    }


#endregion

    #endregion

    #region Utility functions

    #endregion


    #endregion

}